unit uNote;

{
   Package: TIU - TEXT INTEGRATION UTILITIES 
   Date Created: Oct 23, 2006
   Site Name: xxxxxxxxxxxxxxxx
   Developers: zzzzzzzzzuser, SGT
   Description: Mobile Electronic Documentation 
   Note: This unit requires XWB*1.1 and TIU*1*244 in order to run. 
         Includes Template routines from CPRS
}

interface

uses SysUtils,
      { TODO -oherb -c2007 : Adding variants for vartab }
      variants;

type
  TNoteRecord = class(TObject)
    public
      Title:string;
      Caption:string;
      Text:string;
      Saved:boolean;
      Data:pointer;
      NoteID:integer;
      Imported:boolean;
      { TODO -oHerb -cFix Error : Convert DFN from Integer to INT64 for large DFNs }
//      ParentDFN:integer;
      ParentDFN: INT64;
      function SaveNote(con:OleVariant):boolean;
      function SetNoteData(rcdPat:OleVariant):boolean;
      function DeleteNote(con:OleVariant):boolean;
  end;

  TNoteRecordArr = array of TNoteRecord;
  procedure CleanNotesArr(naList:TNoteRecordArr);
  function BoolToStr(val:boolean):string;  
implementation

uses uDB, uImporter;

{TNote}

function TNoteRecord.SaveNote(con:OleVariant):boolean;
  var
    strSave:string;
  begin
    //Save or Update?
      if Self.NoteID > 0 then
        begin
          //Update (Only import status)
            strSave := 'UPDATE Notes SET ntImported = ' + BoolToStr(Self.Imported) + ', ntImportDate = Now() WHERE ntRfnbr = ' + IntToStr(Self.NoteID);
          //Now save it
            Result := ExecuteQuery(con,strSave);
        end
      else
        Result := False;  //No NoteID


  end;

function TNoteRecord.DeleteNote(con:OleVariant):boolean;
  var
    strDel:string;
  begin
    //Default
      DeleteNote := False;
    //Can we delete this from the db?
      if Self.NoteID <= 0 then Exit;  //No.
    //Create our delete query
      strDel := 'DELETE from Notes WHERE ntRfnbr = ' + IntToStr(Self.NoteID);
    //Now delete it
      Result := ExecuteQuery(con,strDel);
  end;

function TNoteRecord.SetNoteData(rcdPat:OleVariant):boolean;
  var
    { TODO -oHerb -cFix Error : Convert DFN from Integer to INT64 for large DFNs }
//    ParentDFN,NoteID:integer;
    ParentDFN : INT64;
    NoteID:integer;
    Caption,Title,Note:string;
    Imported:boolean;
  begin
    //Default
      Result := False;
    //Ensure we have a recordset object
      if not VarType(rcdPat) = VarDispatch then
        Exit;
    //Now set our patient
      try
        //Get our values
{ TODO -oherb -cInvalid Integer : 
Still having invalid integer issues.  Changing integer to INt64 to fix
the problem.  12/17/2009 }
//          ParentDFN := StrToInt(Nz(rcdPat.Fields['ntPatNbr'],'-1'));
          ParentDFN := StrToInt64(Nz(rcdPat.Fields['ntPatNbr'],'-1'));
          NoteID := StrToInt(Nz(rcdPat.Fields['ntRfnbr'],'-1'));
          Title := Nz(rcdPat.Fields['ntNoteTitle'],'');
          Caption := Nz(rcdPat.Fields['ntCaption'],'');
          Note := Nz(rcdPat.Fields['ntNote'],'');

           { TODO -oherb -c2007 Upgrade : Now returns True or False instead of a value }
//          Imported := (Nz(rcdPat.Fields['ntImported'],'0') <> '0');
          Imported := (Nz(rcdPat.Fields['ntImported'],'False') <> 'False');


        //Everything's ok
          Self.ParentDFN := ParentDFN;
          Self.NoteID := NoteID;
          Self.Caption := Caption;
          Self.Title := Title;
          Self.Text := Note;
          Self.Saved := True;
          Self.Imported := Imported;

          Result := True;
      except
      end;
  end;

procedure CleanNotesArr(naList:TNoteRecordArr);
var
  i:integer;
  ntItem:TNoteRecord;
begin
  if not assigned(naList) then
    Exit;

  for i:= Low(naList) to High(naList) do
    begin
      ntItem := naList[i];
      if assigned(ntItem) then
        begin
          ntItem.Free;
          naList[i] := nil;
        end;
    end;
end;

function BoolToStr(val:boolean):string;
begin
  if val then
    Result := 'TRUE'
  else
    Result := 'FALSE';
end;
end.
